<?php

class UserAdministratorPasswordForm extends CFormModel
{
	public $emailOrLogin;
	public $password;
	public $passwordRepeat;
	public $userModel;//from validEmailOrLogin rule

	private $identity;

	public function rules()
	{
		return array(
			array('emailOrLogin', 'validEmailOrLogin','on'=>'sendEmail'),

			array('passwordRepeat', 'compare', 'compareAttribute'=>'password','on'=>'setPassword'),
			array('password', 'required','on'=>'setPassword'),
		);
	}

	public function validEmailOrLogin()
	{
		$this->userModel = Admin::model()->find(array(
			'condition' => '"email" = :emailOrLogin OR "login" = :emailOrLogin',
			'params' => array(':emailOrLogin' => $this->emailOrLogin),
		));
		if (empty($this->userModel))
			$this->userModel = Uzytkownik::model()->find(array(
				'condition' => '"email" = :emailOrPesel OR "pesel" = :emailOrPesel',
				'params' => array(':emailOrPesel' => $this->emailOrLogin),
			));

		if(empty($this->userModel))
			$this->addError('emailOrLogin','Podane dane są nieprawidłowe.');
	}

	public function attributeLabels()
	{
		return array(
			'emailOrLogin'=>'Podaj swój e-mail lub login:',
			'password'=>'Podaj nowe hasło',
			'passwordRepeat'=>'Powtórz nowe hasło',
		);
	}
}
